//  Use the OpenWeather library: https://github.com/Bodmer/OpenWeather

//  The weather icons and fonts are in the sketch data folder, press Ctrl+K
//  to view.

// The ESP32 board support package 2.0.0 or later must be loaded in the
// Arduino boards manager to provide LittleFS support.

//            >>>       IMPORTANT TO PREVENT CRASHES      <<<
//>>>>>>  Set LittleFS to at least 1.5Mbytes before uploading files  <<<<<<

//            >>>           DON'T FORGET THIS             <<<
//  Upload the fonts and icons to LittleFS using the "Tools" menu option.

// You can change the "User_Setup.h" file inside the OpenWeather
// to shows the data stream from the server.

//////////////////////////////
// Settings defined below

#define WIFI_SSID      "My Livebox"
#define WIFI_PASSWORD  "My Password"

//#define TIMEZONE UK // See NTP_Time.h tab for other "Zone references", UK, usMT etc
#define TIMEZONE euCET

// Update every 15 minutes, up to 1000 request per day are free (viz average of ~40 per hour)
const int UPDATE_INTERVAL_SECS = 15UL * 60UL;  // 15 minutes

// Pins for the TFT interface are defined in the User_Config.h file inside the TFT_eSPI library

// For units use "metric" or "imperial"
const String units = "metric";

// Sign up for a key and read API configuration info here:
// https://openweathermap.org/, change x's to your API key
const String api_key = "My Key from OpenWeather";

// Set the forecast longitude and latitude to at least 4 decimal places

// New York, Empire State Building
// 40.749778527083656, -73.98629815117553
const String latitude =  "My Latitude from Google Maps"; // 90.0000 to -90.0000 negative for Southern hemisphere
const String longitude = "My Longitude from Google Maps"; // 180.000 to -180.000 negative for West
// For language codes see https://openweathermap.org/current#multi
const String language = "fr";  // Default language = en = English

// Short day of week abbreviations used in 4 day forecast (change to your language)
const String shortDOW[8] = { "???", "DIM", "LUN", "MAR", "MER", "JEU", "VEN", "SAM" };

// Change the labels to your language here:
const char sunStr[] = "Soleil";
const char cloudStr[] = "Nuages";
const char humidityStr[] = "Humidite";
const String moonPhase[8] = { "Nouvelle", "1er croissant", "1er quartier", "Croissante", "Pleine", "Decroissante", "Der quartier", "Der croissant" };

// End of user settings
//////////////////////////////
