/****************************************************************************
* BME280 PRESSURE, TEMPERATURE, HUMIDITY AND ALTITUDE
* ===========================================================================
*             
* BME 280 sensor module is used to measure the atmospheric, pressure,
* temperature, humidity, and the altitude.The results are displayed on the
* TFT display
*
* ESP 32 in mode SLEEP
* 
* Program: BME280
* Jm defais
* January 2026
* See Https://www.electroloisirs.fr
*********************************************************************************/
#include < SPI.h >
#include < TFT_eSPI.h >
#include < Adafruit_BME280.h >
#include < Wire.h >

#define I2C_SDA 27
#define I2C_SCL 22
RTC_DATA_ATTR int bootCount = 0;			// Variable to RTC counter

TwoWire MyWire = TwoWire(0);

Adafruit_BME280 bme;                       // Create a BME 280 object

TFT_eSPI tft = TFT_eSPI();

#define SCREEN_WIDTH 320
#define SCREEN_HEIGHT 240
#define FONT_SIZE2 2
#define FONT_SIZE4 4


//
// This function updates the TFT display
//
void Update()
{
  // Draw separators on the display

  tft.fillScreen(TFT_BLACK);
  tft.setTextColor(TFT_WHITE, TFT_BLACK);

  tft.drawFastHLine(0, 188, 319, TFT_BLUE);
  tft.drawFastVLine(170, 0, 239, TFT_BLUE);
  tft.drawFastHLine(170, 65, 239, TFT_BLUE);
  tft.drawFastHLine(170, 130, 239, TFT_BLUE);


// temperature, pressure, humidity, and altitude draw on display


  tft.drawString("Temperature", 175, 5, FONT_SIZE4);
  String tmp = String(bme.readTemperature()) + " C";
  tft.drawString(tmp, 195, 35, FONT_SIZE4);

  tft.drawString("Pressure", 190, 70, FONT_SIZE4);
  String pres = String(bme.readPressure() / 100) + " hPa";
  tft.drawString(pres, 176, 100, FONT_SIZE4);

  tft.drawString("Humidity", 190, 135, FONT_SIZE4);
  String humi = String(bme.readHumidity()) + " %";
  tft.drawString(humi, 190, 160, FONT_SIZE4);

  tft.drawString("Altitude", 190, 195, FONT_SIZE4);
  String alti = String(bme.readAltitude(1013.25)) + " m";
  tft.drawString(alti, 186, 217, FONT_SIZE4);

  tft.setTextColor(TFT_RED);
  tft.drawString("Jm Defais", 50, 205, FONT_SIZE2);

  tft.setTextColor(TFT_ORANGE);
  tft.drawString("HOME", 50, 80, FONT_SIZE4);

}

void setup() 
{	
  ++bootCount;
  esp_sleep_enable_ext0_wakeup(GPIO_NUM_35,0);            // LOW Signal on GPIO 35 wake up ESP32
  delay(500);  
  Serial.begin(9600);
  MyWire.begin(I2C_SDA, I2C_SCL, 100000);

  bool status = bme.begin(0x76, &MyWire);                 //BME 280 address 0x76

  if(!status)
  {
    Serial.println("Error in initializing the sensor");
    while(1);
  }
 
  tft.init();
  tft.setRotation(1);
}

//
// Main program loop. The TFT display is updated every 5 seconds
//
void loop() 
{
  char k ;
  for(k = 0; k < 6; k++)
  {
    Update();                  // Update the TFT
    delay(5000);
  }
  
  esp_deep_sleep_start();    // ESP 32 sleep      
}

